/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXPROJECTROOT_P_H
#define QKNXPROJECTROOT_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt KNX API.  It exists for the convenience
// of the Qt KNX implementation.  This header file may change from version
// to version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/qdatetime.h>
#include <QtCore/qstring.h>
#include <QtCore/qvector.h>
#include <QtKnx/private/qknxinstallation_p.h>
#include <QtKnx/private/qknxprojectinformation_p.h>
#include <QtKnx/private/qknxprojectutils_p.h>

QT_BEGIN_NAMESPACE

struct Q_KNX_EXPORT QKnxAddinData
{
    Q_DECLARE_TR_FUNCTIONS(QKnxAddinData)

public:
    QString AddinId; // non-colonized name, pattern [\i-[:]][\c-[:]]*
    QString Name; // 50 character max.

    bool parseElement(QXmlStreamReader *reader, bool pedantic);
};

struct Q_KNX_EXPORT QKnxProject
{
    Q_DECLARE_TR_FUNCTIONS(QKnxProject)

public:
    QString Id; // non-colonized name, pattern [\i-[:]][\c-[:]]*

    QVector<QKnxProjectInformation> ProjectInformation; // 0..1
    QVector<QKnxInstallation> Installations; // 1..16
    QVector<QKnxUserFile> UserFiles; // 0..n
    QVector<QKnxAddinData> AddinData; // 0..n

    bool parseElement(QXmlStreamReader *reader, bool pedantic);
};

struct Q_KNX_EXPORT QKnxProjectRoot
{
    Q_DECLARE_TR_FUNCTIONS(QKnxProjectRoot)

public:
    QString CreatedBy; // optional
    QString ToolVersion; // optional

    QVector<QKnxProject> Project; // 0..n

    bool parseElement(QXmlStreamReader *reader, bool pedantic);
};

QT_END_NAMESPACE

#endif
